/*
 * plcnvm
 *
 * PLC NVM manager for slave PLC chips.
 * Ethernet-related header file.
 *
 * Boots an external PLC chip loading a PLC firmware image through Ethernet
 *
 * Copyright (C) 2015, Broadcom Corporation. All Rights Reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef _PLCNVM_ETH_H_
#define _PLCNVM_ETH_H_


/*************************************************
 *                Pulic Defines
 *************************************************/

/* NVMFwPkts dest MAC addr offset */
#define NVMFWPKTS_DSTMAC_OFFSET  0x00

/* NVMFwPkts src MAC addr offset */
#define NVMFWPKTS_SRCMAC_OFFSET  0x06

/* NVMFwPkts LLC/SNAP offset */
#define NVMFWPKTS_LLC_OFFSET  0x0C

/* NVMFwPkts OUI offset */
#define NVMFWPKTS_OUI_OFFSET  0x11

/* NVMFwPkts ETHERTYPE offset */
#define NVMFWPKTS_ETHERTYPE_OFFSET  0x14

/* NVMFwPkts VER offset */
#define NVMFWPKTS_VER_OFFSET  0x16

/* NVMFwPkts STYP offset */
#define NVMFWPKTS_STYP_OFFSET  0x17

/* NVMFwPkts DATA offset */
#define NVMFWPKTS_DATA_OFFSET  0x18

/* NVMFwPkts ETHERTYPE */
#define NVMFWPKTS_ETHERTYPE 0x8912

/* NVMFwPkts protocol version */
#define NVMFWPKTS_PACKET_VERSION       0x01   /* NVMFwPkts version */



/***************************************************
*           Public Function Prototypes
***************************************************/

int NVMFwPktsEthInit(void);
int NVMFwPktsEthSend(unsigned char subtype, unsigned char *data,
                     unsigned short length);
int NVMFwPktsEthReceive(unsigned char *pkt_data);

#endif /* _PLCNVM_ETH_H_ */
